/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api.license;

import cn.kinyun.wework.sdk.entity.license.order.*;
import cn.kinyun.wework.sdk.exception.WeworkException;

/**
 * Auto generate interface of LicenseOrderApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2023/05/31
 */
public interface LicenseOrderClient {

    /**
     * getOrder
     *
     * @param corpId
     * @param orderId
     * @return GetOrderResp
     * @throws WeworkException
     */
    GetOrderResp getOrder(String corpId, String orderId) throws WeworkException;

    /**
     * createNewOrder
     *
     * @param corpId
     * @param req
     * @return String
     * @throws WeworkException
     */
    String createNewOrder(String corpId, CreateNewOrderReq req) throws WeworkException;

    /**
     * createRenewOrderJob
     *
     * @param corpId
     * @param req
     * @return CreateRenewOrderJobResp
     * @throws WeworkException
     */
    CreateRenewOrderJobResp createRenewOrderJob(String corpId, CreateRenewOrderJobReq req) throws WeworkException;

    /**
     * submitOrderJob
     *
     * @param corpId
     * @param req
     * @return String
     * @throws WeworkException
     */
    String submitOrderJob(String corpId, SubmitOrderJobReq req) throws WeworkException;

    /**
     * listOrder
     *
     * @param corpId
     * @param req
     * @return ListOrderResp
     * @throws WeworkException
     */
    ListOrderResp listOrder(String corpId, ListOrderReq req) throws WeworkException;

    /**
     * listOrderAccount
     *
     * @param corpId
     * @param req
     * @return ListOrderAccountResp
     * @throws WeworkException
     */
    ListOrderAccountResp listOrderAccount(String corpId, ListOrderAccountReq req) throws WeworkException;

    /**
     * cancelOrder
     *
     * @param corpId
     * @param req
     * @throws WeworkException
     */
    void cancelOrder(String corpId, CancelOrderReq req) throws WeworkException;

    /**
     * createNewOrderJob
     *
     * @param corpId
     * @param req
     * @return CreateNewOrderJobResp
     * @throws WeworkException
     */
    CreateNewOrderJobResp createNewOrderJob(String corpId, CreateNewOrderJobReq req) throws WeworkException;

    /**
     * submitNewOrderJob
     *
     * @param corpId
     * @param req
     * @return String
     * @throws WeworkException
     */
    String submitNewOrderJob(String corpId, SubmitNewOrderJobReq req) throws WeworkException;

    /**
     * getNewOrderJob
     *
     * @param corpId
     * @param jobId
     * @return NewOrderJobResultResp
     * @throws WeworkException
     */
    NewOrderJobResultResp getNewOrderJob(String corpId, String jobId) throws WeworkException;

    /**
     * getUnionOrder
     *
     * @param corpId
     * @param req
     * @return GetUnionOrderResp
     * @throws WeworkException
     */
    GetUnionOrderResp getUnionOrder(String corpId, GetUnionOrderReq req) throws WeworkException;

}