/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.entity.contact.user.UserInfo;
import cn.kinyun.wework.sdk.entity.contact.user.UserSimpleInfo;
import cn.kinyun.wework.sdk.exception.WeworkException;

import java.util.List;

/**
 * Auto generate interface of UserApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface UserClient {

    /**
     * simpleList
     *
     * @param corpId
     * @param departmentId
     * @param fetchChild
     * @return List<UserSimpleInfo>
     * @throws WeworkException
     */
    List<UserSimpleInfo> simpleList(String corpId, Integer departmentId, Integer fetchChild) throws WeworkException;

    /**
     * updateDepartment
     *
     * @param corpId
     * @param userId
     * @param department
     * @throws WeworkException
     */
    void updateDepartment(String corpId, String userId, List<Integer> department) throws WeworkException;

    /**
     * get
     *
     * @param corpId
     * @param userId
     * @return UserInfo
     * @throws WeworkException
     */
    UserInfo get(String corpId, String userId) throws WeworkException;

    /**
     * update
     *
     * @param corpId
     * @param userInfo
     * @throws WeworkException
     */
    void update(String corpId, UserInfo userInfo) throws WeworkException;

    /**
     * create
     *
     * @param corpId
     * @param userInfo
     * @throws WeworkException
     */
    void create(String corpId, UserInfo userInfo) throws WeworkException;

    /**
     * list
     *
     * @param corpId
     * @param departmentId
     * @param fetchChild
     * @return List<UserInfo>
     * @throws WeworkException
     */
    List<UserInfo> list(String corpId, Integer departmentId, Integer fetchChild) throws WeworkException;

}