/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.api.req.ApplyEventReq;
import cn.kinyun.wework.sdk.api.req.ApproveDetailReq;
import cn.kinyun.wework.sdk.api.req.OaTemplateDetailReq;
import cn.kinyun.wework.sdk.entity.oa.ApplyEventResp;
import cn.kinyun.wework.sdk.entity.oa.ApproveDetailResp;
import cn.kinyun.wework.sdk.entity.oa.TemplateDetailResp;
import cn.kinyun.wework.sdk.exception.WeworkException;

/**
 * Auto generate interface of OaApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface OaClient {

    /**
     * templateDetail
     *
     * @param corpId
     * @param params
     * @return TemplateDetailResp
     * @throws WeworkException
     */
    TemplateDetailResp templateDetail(String corpId, OaTemplateDetailReq params) throws WeworkException;

    /**
     * applyEvent
     *
     * @param corpId
     * @param params
     * @return ApplyEventResp
     * @throws WeworkException
     */
    ApplyEventResp applyEvent(String corpId, ApplyEventReq params) throws WeworkException;

    /**
     * approveDetail
     *
     * @param corpId
     * @param params
     * @return ApproveDetailResp
     * @throws WeworkException
     */
    ApproveDetailResp approveDetail(String corpId, ApproveDetailReq params) throws WeworkException;

}