/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.annotation.Retry;
import cn.kinyun.wework.sdk.entity.external.contact.*;
import cn.kinyun.wework.sdk.exception.CrossBarrierException;
import cn.kinyun.wework.sdk.exception.WeworkException;

import java.util.List;

/**
 * Auto generate interface of ExternalContactApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface ExternalContactClient {

    /**
     * remark
     *
     * @param corpId
     * @param remark
     * @throws WeworkException
     * @throws CrossBarrierException
     */
    @Retry
    void remark(String corpId, ExternalContactRemark remark) throws WeworkException, CrossBarrierException;

    /**
     * 异步调用remark
     *
     * @param corpId
     * @param remark
     * @return requestId
     */
    @Retry
    String asyncRemark(String corpId, ExternalContactRemark remark);

    /**
     * getDetail
     *
     * @param corpId
     * @param externalUserId
     * @param cursor
     * @return ExternalContactResp
     * @throws WeworkException
     */
    ExternalContactResp getDetail(String corpId, String externalUserId, String cursor) throws WeworkException;

    /**
     * getDetailList
     *
     * @param corpId
     * @param userId
     * @param cursor
     * @param limit
     * @return ExternalContactDetailList
     * @throws WeworkException
     */
    ExternalContactDetailList getDetailList(String corpId, String userId, String cursor, Integer limit) throws WeworkException;

    /**
     * unionIdToExternalUserId
     *
     * @param corpId
     * @param unionId
     * @param openId
     * @return String
     * @throws WeworkException
     * @throws CrossBarrierException
     */
    String unionIdToExternalUserId(String corpId, String unionId, String openId) throws WeworkException, CrossBarrierException;

    /**
     * unionIdConvert
     *
     * @param corpId
     * @param unionId
     * @param openId
     * @return ExternalUserIdResp
     * @throws WeworkException
     * @throws CrossBarrierException
     */
    ExternalUserIdResp unionIdConvert(String corpId, String unionId, String openId) throws WeworkException, CrossBarrierException;

    /**
     * userIdGetPendingId
     *
     * @param corpId
     * @param externalUserIds
     * @return ExternalPendingIdResp
     * @throws WeworkException
     * @throws CrossBarrierException
     */
    ExternalPendingIdResp userIdGetPendingId(String corpId, List<String> externalUserIds) throws WeworkException, CrossBarrierException;

    /**
     * list
     *
     * @param corpId
     * @param userId
     * @return List<String>
     * @throws WeworkException
     */
    List<String> list(String corpId, String userId) throws WeworkException;

}