/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ChatMsgType {
    TEXT("text", "\u6587\u672c"),
    IMAGE("image", "\u56fe\u7247"),
    REVOKE("revoke", "\u64a4\u56de\u6d88\u606f"),
    AGREE("agree", "\u540c\u610f\u5b58\u6863\u4f1a\u8bdd\u5185\u5bb9"),
    DISAGREE("disagree", "\u4e0d\u540c\u610f\u5b58\u6863\u4f1a\u8bdd\u5185\u5bb9"),
    VOICE("voice", "\u8bed\u97f3"),
    VIDEO("video", "\u89c6\u9891"),
    CARD("card", "\u540d\u7247"),
    LOCATION("location", "\u4f4d\u7f6e"),
    EMOTION("emotion", "\u8868\u60c5"),
    FILE("file", "\u6587\u4ef6"),
    LINK("link", "\u94fe\u63a5"),
    WEAPP("weapp", "\u5c0f\u7a0b\u5e8f\u6d88\u606f"),
    CHATRECORD("chatrecord", "\u4f1a\u8bdd\u8bb0\u5f55\u6d88\u606f"),
    TODO("todo", "\u5f85\u529e\u6d88\u606f"),
    VOTE("vote", "\u6295\u7968\u6d88\u606f"),
    COLLECT("collect", "\u586b\u8868\u6d88\u606f"),
    REDPACKET("redpacket", "\u7ea2\u5305\u6d88\u606f"),
    MEETING("meeting", "\u4f1a\u8bae\u9080\u8bf7\u6d88\u606f"),
    SWITCH("switch", "\u5207\u6362\u4f01\u4e1a\u65e5\u5fd7"),
    DOCMSG("docmsg", "\u5728\u7ebf\u6587\u6863\u6d88\u606f"),
    MARKDOWN("", "MarkDown\u683c\u5f0f\u6d88\u606f"),
    NEWS("news", "\u56fe\u6587\u6d88\u606f"),
    CALENDAR("calendar", "\u65e5\u7a0b\u6d88\u606f"),
    MIXED("mixed", "\u6df7\u5408\u6d88\u606f"),
    MEETING_VOICE_CALL("meeting_voice_call", "\u97f3\u9891\u5b58\u6863\u6d88\u606f"),
    VOIP_DOC_SHARE("voip_doc_share", "\u97f3\u9891\u5171\u4eab\u6587\u6863\u6d88\u606f"),
    EXTERNAL_REDPACKET("external_redpacket", "\u4e92\u901a\u7ea2\u5305\u6d88\u606f"),
    SPHFEED("sphfeed", "\u89c6\u9891\u53f7\u6d88\u606f"),
    VOIPTEXT("voiptext", "\u97f3\u89c6\u9891\u901a\u8bdd"),
    QYDISKFILE("qydiskfile", "\u5fae\u76d8\u6587\u4ef6");

    private final String value;
    private final String desc;
    private static final Map<String, ChatMsgType> CACHE;

    private ChatMsgType(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static ChatMsgType getType(String value) {
        return CACHE.get(value);
    }

    static {
        CACHE = Arrays.stream(ChatMsgType.values()).collect(Collectors.toMap(ChatMsgType::getValue, Function.identity()));
    }
}

