/**
 * kuaikeguanjia.com Inc. Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.enums;

/**
 * 应用授权作用域。
 * <p><ul>
 * <li>snsapi_base：静默授权，可获取成员的基础信息（UserId与DeviceId）；</li>
 * <li>snsapi_userinfo：静默授权，可获取成员的详细信息，但不包含手机、邮箱等敏感信息；</li>
 * <li>snsapi_privateinfo：手动授权，可获取成员的详细信息，包含手机、邮箱等敏感信息（已不再支持获取手机号/邮箱）。</li>
 * </ul></p>
 * 
 * @title SnsapiScope
 * @author yanmaoyuan
 * @date 2021年3月1日
 * @version 1.0
 * @link https://work.weixin.qq.com/api/doc/90001/90143/91120
 */
@SuppressWarnings("squid:S115")
public enum SnsapiScope {

    SNSAPI_BASE("snsapi_base", "静默授权"),
    SNSAPI_USERINFO("snsapi_userinfo", "基本信息"),
    SNSAPI_PRIVATEINFO("snsapi_privateinfo", "隐私信息");

    private final String value;
    private final String desc;

    SnsapiScope(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
