package cn.kinyun.wework.sdk.enums;

/**
 * 审批流程控件类型
 */
public enum FlowControlEnum  {

    TEXT("Text", "文本"),
    TEXTAREA("Textarea", "多行文本"),
    NUMBER("Number", "数字"),
    MONEY("Money", "金额"),
    DATE("Date", "日期/日期+时间"),
    SELECTOR("Selector", "单选/多选"),
    CONTACT("Contact", "成员/部门"),
    TIPS("Tips", "说明文字"),
    FILE("File", "附件"),
    TABLE("Table", "明细"),
    LOCATION("Location", "位置"),
    RELATED_APPROVAL("RelatedApproval", "关联审批单"),
    FORMULA("Formula", "公式"),
    DATE_RANGE("DateRange", "时长");

    private final String value;
    private final String desc;

    FlowControlEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
