/**
 * kuaikeguanjia.com Inc. Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.suite;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;

import lombok.Data;

/**
 * 共享了应用的企业信息，仅当由企业互联或者上下游共享应用触发的安装时才返回
 * 
 * @title ShareFrom
 * @author yanmaoyuan
 * @date 2021年2月25日
 * @version 1.0
 */
@Data
public class ShareFrom implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 共享了应用的企业信息，仅当企业互联或者上下游共享应用触发的安装时才返回
     */
    @JsonAlias("corpid")
    private String corpId;

    /**
     * 共享的途径，0表示企业互联，1表示上下游
     */
    @JsonAlias("share_type")
    private Integer shareType;
}