/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.provider;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.wework.sdk.entity.ErrorCode;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @title LoginInfo
 * @author yanmaoyuan
 * @date 2021年4月30日
 * @version 1.0
 * @see https://open.work.weixin.qq.com/api/doc/90001/90143/91125
 */
@Data
@EqualsAndHashCode(callSuper= true)
public class LoginInfo extends ErrorCode {

    private static final long serialVersionUID = 1L;

    /**
     * 登录用户的类型：1.创建者 2.内部系统管理员 3.外部系统管理员 4.分级管理员 5.成员
     */
    @JsonAlias("usertype")
    private Integer userType;

    /**
     * 登录用户的信息
     */
    @JsonAlias("user_info")
    private UserInfo userInfo;

    /**
     * 授权方企业信息
     */
    @JsonAlias("corp_info")
    private CorpInfo corpInfo;

    /**
     * 该管理员在该提供商中能使用的应用列表，当登录用户为管理员时返回
     */
    @JsonAlias("agent")
    private List<Agent> agent;

    /**
     * 该管理员在该提供商中能使用的应用列表，当登录用户为管理员时返回
     */
    @JsonAlias("auth_info")
    private AuthInfo authInfo;
}
