/**
 * kuaikeguanjia.com Inc. Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.oauth2;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.wework.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @title Userinfo3rd
 * @author yanmaoyuan
 * @date 2021年2月26日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class Userinfo3rd extends ErrorCode {

    private static final long serialVersionUID = 1L;

    /**
     * 用户所属企业的corpid
     */
    @JsonAlias("CorpId")
    private String corpId;

    /**
     * 用户在企业内的UserID，如果该企业与第三方应用有授权关系时，返回明文UserId，否则返回密文UserId
     */
    @JsonAlias("UserId")
    private String userId;

    /**
     * 手机设备号(由企业微信在安装时随机生成，删除重装会改变，升级不受影响)
     */
    @JsonAlias("DeviceId")
    private String deviceId;

    /**
     * 成员票据，最大为512字节。
     * <p>scope为snsapi_userinfo或snsapi_privateinfo，且用户在应用可见范围之内时返回此参数。</p>
     * <p>后续利用该参数可以获取用户信息或敏感信息，参见“第三方使用user_ticket获取成员详情”。</p>
     */
    @JsonAlias("user_ticket")
    private String userTicket;

    /**
     * user_ticket的有效时间（秒），随user_ticket一起返回
     */
    @JsonAlias("expires_in")
    private Long expiresIn;

    /**
     * 全局唯一。对于同一个服务商，不同应用获取到企业内同一个成员的open_userid是相同的，最多64个字节。仅第三方应用可获取
     */
    @JsonAlias("open_userid")
    private String openUserId;
    
    /**
     * 若用户不属于任何企业，返回OpenId
     * 
     * 非企业成员的标识，对当前服务商唯一。
     */
    @JsonAlias("OpenId")
    private String openId;
}
