package cn.kinyun.wework.sdk.entity.license.order;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import java.util.List;

@Data
public class ListOrderResp extends ErrorCode {
    /**
     * 订单列表
     **/
    @JsonProperty("order_list")
    private List<OrderIdTypeDto> orderList;

    /**
     * 分页游标，再下次请求时填写以获取之后分页的记录
     **/
    @JsonProperty("next_cursor")
    private String nextCursor;

    /**
     * 是否有更多。 0: 没有， 1: 有
     **/
    @JsonProperty("has_more")
    private Integer hasMore;
}
