package cn.kinyun.wework.sdk.entity.external.welcome;

import cn.kinyun.wework.sdk.entity.external.msg.Attachment;
import cn.kinyun.wework.sdk.entity.external.msg.Text;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 新客户欢迎语参数
 * 
 * @see https://work.weixin.qq.com/api/doc/90001/90143/92599
 */
@Data
public class WelcomeMsg implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 通过添加外部联系人事件推送给企业的发送欢迎语的凭证，有效期为20秒
     */
    @JsonProperty("welcome_code")
    private String welcomeCode;

    private Text text;

    private List<Attachment> attachments;
}
