package cn.kinyun.wework.sdk.entity.external.contact;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;

import lombok.Data;

/**
 * 客户详情信息
 */
@Data
public class ExternalContactInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonAlias("external_userid")
    private String externalUserId;

    private String name;

    /**
     * 客户职位
     */
    private String position;

    /**
     * 头像url
     */
    private String avatar;

    /**
     * 外部联系人所在企业的简称，仅当联系人类型是企业微信用户时有此字段
     */
    @JsonAlias("corp_name")
    private String corpName;

    /**
     * 外部联系人所在企业的主体名称，仅当联系人类型是企业微信用户时有此字段
     */
    @JsonAlias("corp_full_name")
    private String corpFullName;

    /**
     * 外部联系人的类型，1表示该外部联系人是微信用户，2表示该外部联系人是企业微信用户
     */
    private Integer type;

    /**
     * 外部联系人性别 0-未知 1-男性 2-女性
     */
    private Integer gender;

    /**
     * 外部联系人在微信开放平台的唯一身份标识（微信unionid），通过此字段企业可将外部联系人与公众号/小程序用户关联起来
     */
    @JsonAlias("unionid")
    private String unionId;

    /**
     * 外部联系人的自定义展示信息，可以有多个字段和多种类型，包括文本，网页和小程序，仅当联系人类型是企业微信用户时有此字段
     */
    @JsonAlias("external_profile")
    private ExternalProfile externalProfile;

}
