/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.chat.msg;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @title Vote
 * @author yanmaoyuan
 * @date 2021年3月18日
 * @version 1.0
 */
@Data
public class Vote implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 投票主题。String类型
     */
    @JsonAlias("votetitle")
    private String voteTitle;

    /**
     * 投票选项，可能多个内容。String数组
     */
    @JsonAlias("voteitem")
    private List<String> voteItem;

    /**
     * 投票类型.101发起投票、102参与投票。Uint32类型
     */
    @JsonAlias("votetype")
    private Integer voteType;

    /**
     * 投票id，方便将参与投票消息与发起投票消息进行前后对照。String类型
     */
    @JsonAlias("voteid")
    private String voteId;
}
