package cn.kinyun.wework.sdk.entity.chat.msg;

import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;

import java.io.Serializable;

/**
 * 视频号消息
 *
 * @author yanmaoyuan
 * @date 2022/12/14
 */
@Data
public class SphFeed implements Serializable {
    /**
     * 视频号消息类型。2 图片、4 视频、9 直播。Uint32类型
     */
    @JsonAlias("feed_type")
    private Integer feedType;
    /**
     * 视频号账号名称。String类型
     */
    @JsonAlias("sph_name")
    private String sphName;
    /**
     * 视频号消息描述。String类型
     */
    @JsonAlias("feed_desc")
    private String feedDesc;
}
