/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.chat.msg;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;

import lombok.Data;

/**
 * @title RedPacket
 * @author yanmaoyuan
 * @date 2021年3月18日
 * @version 1.0
 */
@Data
public class RedPacket implements Serializable {
    
    private static final long serialVersionUID = 1L;

    /**
     * 红包消息类型。1 普通红包、2 拼手气群红包、3 激励群红包。Uint32类型
     */
    private Integer type;

    /**
     * 红包祝福语。String类型
     */
    private String wish;

    /**
     * 红包总个数。Uint32类型
     */
    @JsonAlias("totalcnt")
    private Integer totalCnt;

    /**
     * 红包总金额。Uint32类型，单位为分。
     */
    @JsonAlias("totalamount")
    private Integer totalAmount;
}
