/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.chat.msg;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @title MeetingVoiceCall
 * @author yanmaoyuan
 * @date 2021年3月22日
 * @version 1.0
 */
@Data
public class MeetingVoiceCall implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 音频结束时间。uint32类型
     */
    @JsonAlias("endtime")
    private Long endTime;

    /**
     * 音频媒体下载的id。String类型
     */
    private String sdkfileid;

    /**
     * 文档分享
     */
    @JsonAlias("demofiledata")
    private List<DemoFileData> demoFileData;

    /**
     * 屏幕共享
     */
    @JsonAlias("sharescreendata")
    private List<ShareScreenData> shareScreenData;

}