/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.chat.msg;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;

import lombok.Data;

/**
 * @title Link
 * @author yanmaoyuan
 * @date 2021年3月18日
 * @version 1.0
 */
@Data
public class Link implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 消息标题。String类型
     */
    private String title;

    /**
     * 消息描述。String类型
     */
    private String description;

    /**
     * 链接url地址。String类型
     */
    @JsonAlias("link_url")
    private String linkUrl;

    /**
     * 链接图片url。String类型
     */
    @JsonAlias("image_url")
    private String imageUrl;
}
