/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.callback.suite.external;

import cn.kinyun.wework.sdk.callback.suite.BaseSuiteEvent;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 客户同意进行聊天内容存档事件回调
 * 
 * ChangeType   此时固定为msg_audit_approved
 * 
 * @title MsgAuditApproved
 * @author yanmaoyuan
 * @date 2021年4月26日
 * @version 1.0
 * @link https://developer.work.weixin.qq.com/document/path/92005
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class MsgAuditApproved extends BaseSuiteEvent {
    
    private static final long serialVersionUID = 1L;

    /**
     * 企业服务人员的UserID
     */
    @JacksonXmlProperty(localName = "UserID")
    private String userId;

    /**
     * 外部联系人的userid，注意不是企业成员的帐号
     */
    @JacksonXmlProperty(localName = "ExternalUserID")
    private String externalContactId;

    /**
     * 欢迎语code，可用于发送欢迎语
     */
    @JacksonXmlProperty(localName = "WelcomeCode")
    private String welcomeCode;
}
