/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.callback.agent.event;

import cn.kinyun.wework.sdk.callback.agent.BaseAgentEvent;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @title ScanCode
 * @author yanmaoyuan
 * @date 2021年4月26日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ScanCode extends BaseAgentEvent {
    
    private static final long serialVersionUID = 1L;

    @JacksonXmlProperty(localName = "ScanCodeInfo")
    private ScanCodeInfo scanCodeInfo;

    @Data
    public static class ScanCodeInfo implements Serializable {
        private static final long serialVersionUID = 1L;
        
        @JacksonXmlProperty(localName = "ScanType")
        private String scanType;

        @JacksonXmlProperty(localName = "ScanResult")
        private String scanResult;
    }
}
