/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.callback.agent.event;

import cn.kinyun.wework.sdk.callback.agent.BaseAgentEvent;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 上报地理位置
 * 
 * Event    事件类型：LOCATION
 * 
 * 成员同意上报地理位置后，每次在进入应用会话时都会上报一次地理位置。
 * 企业可以在管理端修改应用是否需要获取地理位置权限。
 * 
 * @title Location
 * @author yanmaoyuan
 * @date 2021年4月26日
 * @version 1.0
 * @see https://work.weixin.qq.com/api/doc/90001/90143/90376
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class Location extends BaseAgentEvent {
    private static final long serialVersionUID = 1L;

    /**
     * 地理位置纬度
     */
    @JacksonXmlProperty(localName = "Latitude")
    private Double latitude;

    /**
     * 地理位置经度
     */
    @JacksonXmlProperty(localName = "Longitude")
    private Double longitude;

    /**
     * 地理位置精度
     */
    @JacksonXmlProperty(localName = "Precision")
    private Double precision;

    /**
     * app类型，在企业微信固定返回wxwork，在微信不返回该字段
     */
    @JacksonXmlProperty(localName = "AppType")
    private String appType;
}
