package cn.kinyun.wework.sdk.api.req;

import cn.kinyun.wework.sdk.entity.oa.Value;
import cn.kinyun.wework.sdk.enums.FlowControlEnum;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Objects;

/**
 * @author sunwen
 */
@Data
public class Content {

    /**
     * 控件类型：Text-文本；Textarea-多行文本；Number-数字；Money-金额；Date-日期/日期+时间；Selector-单选/多选；
     * Contact-成员/部门；Tips-说明文字；File-附件；Table-明细；
     * Location-位置；RelatedApproval-关联审批单；Formula-公式；DateRange-时长
     *
     * @see cn.kinyun.wework.sdk.enums.FlowControlEnum
     */
    private String control;

    /**
     * 控件id：控件的唯一id，可通过“获取审批模板详情”接口获取
     */
    private String id;

    /**
     * 控件字段名
     */
    private String name;

    /**
     * 控件值 ，需在此为申请人在各个控件中填写内容不同控件有不同的赋值参数
     */
    private Value value;

    /**
     * 是否为必填字段
     */
    private Integer require;

    public void validate() {

        Preconditions.checkArgument(StringUtils.isNotBlank(control), "字段类型不能为空");
        List<String> textControl = Lists.newArrayList(FlowControlEnum.TEXT.getValue(), FlowControlEnum.TEXTAREA.getValue());

        if (Objects.isNull(require) || !require.equals(1)) {
            return;
        }

        if (textControl.contains(control)) {
            Preconditions.checkArgument(StringUtils.isNotBlank(value.getText()), name + "为必填字段,text字段内容不能为空");
        }
        if (StringUtils.equals(FlowControlEnum.DATE.getValue(), control)) {
            Preconditions.checkArgument(Objects.nonNull(value.getDate()), name + "为必填字段,date字段内容不能为空");
        }
        if (StringUtils.equals(FlowControlEnum.NUMBER.getValue(), control)) {
            Preconditions.checkArgument(Objects.nonNull(value.getNewNumber()), name + "为必填字段,number字段内容不能为空");
        }
        if (StringUtils.equals(FlowControlEnum.FILE.getValue(), control)) {
            Preconditions.checkArgument(!CollectionUtils.isEmpty(value.getFiles()), name + "为必填字段,file字段内容不能为空");
        }
    }

}
