/**
 * kuaikeguanjia.com Inc. Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.enums;

/**
 * @title ChatStatusFilter
 * @author yanmaoyuan
 * @date 2021年4月30日
 * @version 1.0
 * @link https://work.weixin.qq.com/api/doc/90000/90135/92120
 */
public enum ChatStatusFilter {

    ALL(0, "所有列表(即不过滤)"),

    TRANSFER_WAIT(1, "离职待继承"),

    TRANSFER_GOING(2, "离职继承中"),

    TRANSFER_DONE(3, "离职继承完成");

    private final int value;
    private final String desc;

    ChatStatusFilter(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
