/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.suite;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.wework.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @title PermanentCode
 * @author yanmaoyuan
 * @date 2021年2月24日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper= true)
public class PermanentCode extends ErrorCode {

    private static final long serialVersionUID = 1L;

    /**
     * 授权方（企业）access_token,最长为512字节
     */
    @JsonAlias("access_token")
    private String accessToken;

    /**
     * 授权方（企业）access_token超时时间
     */
    @JsonAlias("expires_in")
    private Long expires;

    /**
     * 企业微信永久授权码,最长为512字节
     */
    @JsonAlias("permanent_code")
    private String permanentCode;

    @JsonAlias("dealer_corp_info")
    private DealerCorpInfo dealerCorpInfo;

    @JsonAlias("auth_corp_info")
    private AuthCorpInfo authCorpInfo;

    @JsonAlias("auth_info")
    private AuthAgentInfo authInfo;

    @JsonAlias("auth_user_info")
    private AuthUserInfo authUserInfo;

    @JsonAlias("register_code_info")
    private RegisterCodeInfo registerCodeInfo;
}
