package cn.kinyun.wework.sdk.entity.license.order;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import java.io.Serializable;

@Data
public class OrderListDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 订单id
     **/
    @JsonProperty("order_id")
    private String orderId;

    /**
     * 订单类型
     * 1：购买帐号
     * 2：续期帐号
     * 5：历史企业迁移订单
     * 8：多企业新购订单
     **/
    @JsonProperty("order_type")
    private Integer orderType;

    /**
     * 分页游标，再下次请求时填写以获取之后分页的记录
     **/
    @JsonProperty("next_cursor")
    private String nextCursor;

    /**
     * 是否有更多。 0: 没有， 1: 有
     **/
    @JsonProperty("has_more")
    private Integer hasMore;

}
