package cn.kinyun.wework.sdk.entity.license.order;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import java.io.Serializable;

@Data
public class OrderInfoDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 订单号
     **/
    @JsonProperty("order_id")
    private String orderId;

    /**
     * 订单类型，1：购买帐号，2：续期帐号，5：应用版本付费迁移订单，6：历史合同迁移订单
     **/
    @JsonProperty("order_type")
    private Integer orderType;

    /**
     * 订单状态，0：待支付，1：已支付，2：已取消（未支付，订单已关闭）3：未支付，订单已过期，4：申请退款中，5：退款成功，6：退款被拒绝，7：订单已失效（将企业从服务商测试企业列表中移除时会将对应测试企业的所有测试订单置为已失效）
     **/
    @JsonProperty("order_status")
    private Integer orderStatus;

    /**
     * 客户企业id，返回加密的corpid
     **/
    @JsonProperty("corpid")
    private String corpId;

    /**
     * 订单金额，单位分
     **/
    private Integer price;

    /**
     *订单的帐号数详情
     **/
    @JsonProperty("account_count")
    private AccountCountDto accountCountDto;

    /**
     * 帐号购买时长
     **/
    @JsonProperty("account_duration")
    private AccountDurationDto accountDurationDto;

    /**
     * 创建时间
     **/
    @JsonProperty("create_time")
    private Long createTime;

    /**
     * 支付时间。迁移订单不返回该字段
     **/
    @JsonProperty("pay_time")
    private Long payTime;

}
