package cn.kinyun.wework.sdk.entity.license.app;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

@Data
public class GetAppLicenseInfoResp extends ErrorCode {

    /**
     * license检查开启状态。
     * 0：未开启license检查状态（未迁移的历史授权的第三方应用（接入版本付费）或者未达到拦截时间的历史授权的的第三方应用（未接入版本付费）以及代开发应用）
     * 1：已开启license检查状态。若开启且已过试用期，则需要为企业购买license帐号才可以使用
     **/
    @JsonProperty("license_status")
    private Integer licenseStatus;

    /**
     * 应用license试用期信息。仅当license_status为1且应用有试用期时返回该字段。服务商测试企业、历史迁移应用无试用期。
     **/
    @JsonProperty("trail_info")
    private TrailInfoDto trailInfo;

    @JsonProperty("license_check_time")
    private Long licenseCheckTime;

}
