package cn.kinyun.wework.sdk.entity.license.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import java.io.Serializable;

@Data
public class ActiveInfoDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 帐号激活码
     * 必传
     **/
    @JsonProperty("active_code")
    private String activeCode;

    /**
     * 帐号类型：1:基础帐号，2:互通帐号，3:办公帐号
     **/
    private Integer type;

    /**
     * 帐号状态：
     * 1: 未绑定
     * 2: 已绑定且有效
     * 3: 已过期
     * 4: 待转移(企业开启自动激活时，成员离职或者被移出可见范围，第二天凌晨会更新为该状态)
     * 5: 已合并（激活码本身激活了userid，后续使用新的激活码重新激活了该userid，则该码变为已合并状态。若被合并时，该激活码未过期则合并后会重置expire_time为合并时间。若被合并时，激活码已过期则不重置expire_time。注：该状态的激活码是已经失效的，不能重新用于激活或者继承。）
     * 6: 已分配给下游
     **/
    private Integer status;

    /**
     * 帐号绑定激活的企业成员userid，未激活则不返回该字段。返回加密的userid
     **/
    @JsonProperty("userid")
    private String userId;

    /**
     *创建时间，订单支付成功后立即创建。激活码必须在创建时间后的365天内激活。
     **/
    @JsonProperty("create_time")
    private Long createTime;

    /**
     *首次激活绑定用户的时间，未激活则不返回该字段
     **/
    @JsonProperty("active_time")
    private Long active_time;

    /**
     * 过期时间。为首次激活绑定的时间加上购买时长。未激活则不返回该字段
     **/
    @JsonProperty("expire_time")
    private Long expireTime;

    /**
     * 合并信息，合并的激活码或者被合并的激活码才返回该字段。
     **/
    @JsonProperty("merge_info")
    private MergeInfoDto mergeInfo;

    /**
     * 分享信息，当激活码通过上游分配给下游时，获取上游或者下游企业该激活码详情时返回
     **/
    @JsonProperty("share_info")
    private ShareInfoDto shareInfo;

}
