package cn.kinyun.wework.sdk.entity.external.transfer;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 查询转接结果
 */
@Data
@EqualsAndHashCode(callSuper=true)
public class TransferResult extends ErrorCode {
    private static final long serialVersionUID = 1L;

    @JsonAlias("customer")
    private List<Customer> customerList;

    /**
     * 下个分页的起始cursor
     */
    @JsonAlias("next_cursor")
    private String nextCursor;

    @Data
    public static class Customer implements Serializable {

        private static final long serialVersionUID = 7829415235316592122L;
        /**
         * 转接客户的外部联系人userid
         */
        @JsonAlias("external_userid")
        private String externalUserId;

        /**
         * 接替状态， 1-接替完毕 2-等待接替 3-客户拒绝 4-接替成员客户达到上限 5-无接替记录
         */
        private Integer status;

        /**
         * 接替客户的时间，如果是等待接替状态，则为未来的自动接替时间
         * 单位是秒
         */
        @JsonAlias("takeover_time")
        private Long takeoverTime;
    }
}
