package cn.kinyun.wework.sdk.entity.external.groupchat;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 客户群信息详情
 */
@Data
public class ChatDetailInfo implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonAlias("chat_id")
    private String chatId;

    private String name;

    private String owner;

    /**
     * 单位秒
     */
    @JsonAlias("create_time")
    private Long createTime;

    /**
     * 群公告
     */
    private String notice;

    @JsonAlias("member_list")
    private List<ChatMember> memberList;

    private Integer status;

    /**
     * 群管理员列表
     */
    @JsonAlias("admin_list")
    private List<AdminUser> adminList;
}
