package cn.kinyun.wework.sdk.entity.external.customeracquisition;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 查询剩余使用量
 *
 * 企业可通过此接口查询当前剩余的使用量。
 * @link https://developer.work.weixin.qq.com/document/path/97375
 * @author yanmaoyuan
 * @date 2023/5/6
 */
@Data
@EqualsAndHashCode(callSuper=true)
public class CustomerAcquisitionQuota extends ErrorCode {
    private static final long serialVersionUID = 1L;
    private Integer total;// 历史累计使用量
    private Integer balance;// 剩余使用量
}