package cn.kinyun.wework.sdk.entity.external.croptag;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

@Data
public class CorpTagGroup implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("group_id")
    private String groupId;

    /**
     * 标签组名称
     */
    @JsonProperty("group_name")
    private String groupName;

    /**
     * 标签组创建时间
     * 单位秒
     */
    @JsonProperty("create_time")
    private Long createTime;

    /**
     * 标签组排序的次序值，order值大的排序靠前。有效的值范围是[0, 2^32)
     */
    private Long order;

    /**
     * 标签组是否已经被删除，只在指定tag_id进行查询时返回
     */
    private Boolean deleted;

    /**
     * 标签组内的标签列表
     */
    @JsonProperty("tag")
    private List<CorpTag> tagList;
}
