package cn.kinyun.wework.sdk.entity.external.contact;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.wework.sdk.entity.ErrorCode;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper=true)
public class ExternalContactResp extends ErrorCode {
    private static final long serialVersionUID = 1L;

    /**
     * 客户详情信息
     */
    @JsonAlias("external_contact")
    private ExternalContactInfo externalContact;

    /**
     * 客户跟进数据
     */
    @JsonAlias("follow_user")
    private List<FollowUser> followUserList;

    /**
     * 分页的cursor，当跟进人多于500人时返回
     */
    @JsonAlias("next_cursor")
    private String nextCursor;
}
