package cn.kinyun.wework.sdk.entity.contact.user;

import cn.kinyun.wework.sdk.entity.ErrorCode;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 成员的信息
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UserInfo extends ErrorCode {

    private static final long serialVersionUID = 1L;

    /**
     * 成员id
     */
    @JsonProperty("userid")
    private String userId;

    /**
     * 成员名
     */
    private String name;

    /**
     * 所属部门列表
     */
    @JsonProperty("department")
    private List<Integer> department;

    /**
     * 部门排序值，和部门对应
     */
    @JsonProperty("order")
    private List<Integer> order;

    /**
     * 职位信息
     */
    private String position;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 性别 0表示未定义，1表示男性，2表示女性
     */
    private int gender;

    /**
     * 邮箱地址
     */
    private String email;

    /**
     * 企业邮箱。仅对开通企业邮箱的企业有效。长度6~64个字节，且为有效的企业邮箱格式。企业内必须唯一。未填写则系统会为用户生成默认企业邮箱（可修改一次）
     */
    @JsonProperty("biz_mail")
    private String bizMail;

    /**
     * 表示在所在的部门内是否为上级, 和部门对应
     */
    @JsonProperty("is_leader_in_dept")
    private List<Integer> isLeaderInDept;

    @JsonProperty("direct_leader")
    private List<String> directLeader;

    /**
     * 启用/禁用成员。1表示启用成员，0表示禁用成员
     */
    private Integer enable;

    /**
     * 是否邀请该成员使用企业微信（将通过微信服务通知或短信或邮件下发邀请，每天自动下发一次，最多持续3个工作日），默认值为true。
     */
    @JsonProperty("to_invite")
    private Boolean toInvite;

    /**
     * 头像mediaId，更新成员时使用
     */
    @JsonProperty("avatar_mediaid")
    private String avatarMediaid;

    /**
     * 头像url
     */
    private String avatar;

    /**
     * 头像缩略图
     */
    @JsonProperty("thumb_avatar")
    private String thumbAvatar;

    /**
     * 座机号
     */
    private String telephone;

    /**
     * 别名
     */
    private String alias;

    private String address;

    /**
     * 全局唯一。对于同一个服务商，不同应用获取到企业内同一个成员的open_userid是相同的，最多64个字节。仅第三方应用可获取
     */
    @JsonProperty("open_userid")
    private String openUserId;

    @JsonProperty("main_department")
    private Integer mainDepartment;

    /**
     * 扩展属性
     */
    private UserExtAttr extattr;

    /**
     * 激活状态: 1=已激活，2=已禁用，4=未激活，5=退出企业。
     * 已激活代表已激活企业微信或已关注微工作台（原企业号）。未激活代表既未激活企业微信又未关注微工作台（原企业号）。
     */
    private int status;

    @JsonProperty("qr_code")
    private String qrCode;

    /**
     * 对外职位
     */
    @JsonProperty("external_position")
    private String externalPosition;

    /**
     * 对外属性
     */
    @JsonProperty("external_profile")
    private UserExternalProfile externalProfile;
}

