/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.chat.msg;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;

import lombok.Data;

/**
 * @title Voice
 * @author yanmaoyuan
 * @date 2021年3月18日
 * @version 1.0
 */
@Data
public class Voice implements Serializable {
    
    private static final long serialVersionUID = 1L;

    /**
     * 语音消息大小。Uint32类型
     */
    @JsonAlias("voice_size")
    private Integer voiceSize;

    /**
     * 播放长度。Uint32类型
     */
    @JsonAlias("play_length")
    private Integer playLength;

    /**
     * 媒体资源的id信息。String类型
     */
    private String sdkfileid;
    
    /**
     * 资源的md5值，供进行校验。String类型
     */
    private String md5sum;
}
