/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.chat.msg;

import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;

/**
 * @title Info
 * @author yanmaoyuan
 * @date 2021年3月19日
 * @version 1.0
 */
@Data
public class Info implements Serializable {

    private static final long serialVersionUID = 1L;

    private String content;// MarkDown消息

    private List<News> item;// 图文消息

    // 下面2个是音视频通话消息
    /**
     * 通话时长，单位秒，uint32类型
     */
    @JsonAlias("callduration")
    private Integer callDuration;

    /**
     * 通话类型，uint32类型
     * 1; //单人视频通话
     * 2; //单人语音通话
     * 3; //多人视频通话
     * 4; //多人语音通话
     */
    @JsonAlias("invitetype")
    private Integer inviteType;

    // qydiskfile 微盘文件
    /**
     * 文件名称，String类型
     */
    private String filename;
}
