package cn.kinyun.wework.sdk.callback.suite.external;


import cn.kinyun.wework.sdk.callback.suite.BaseSuiteEvent;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 企业客户标签变更事件
 * ChangeType: update
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class UpdateExternalTag extends BaseSuiteEvent {
    private static final long serialVersionUID = 1L;

    /**
     * 标签或标签组的ID
     */
    @JacksonXmlProperty(localName = "Id")
    private String id;

    /**
     * 变更标签时，此项为tag，变更标签组时，此项为tag_group
     */
    @JacksonXmlProperty(localName = "TagType")
    private String tagType;
}
