/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.callback.suite.contact;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.io.Serializable;

import lombok.Data;

/**
 * 异步任务完成通知
 * 
 * Event    事件类型：batch_job_result
 * 
 * @title BatchJobResult
 * @author yanmaoyuan
 * @date 2021年4月26日
 * @version 1.0
 * @see https://work.weixin.qq.com/api/doc/90001/90143/91135
 */
@Data
@JacksonXmlRootElement(localName = "xml")
public class BatchJobResult implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 企业微信CorpID
     */
    @JacksonXmlProperty(localName = "ToUserName")
    private String toUserName;

    /**
     * 成员UserID
     */
    @JacksonXmlProperty(localName = "FromUserName")
    private String fromUserName;

    /**
     * 消息创建时间
     */
    @JacksonXmlProperty(localName = "CreateTime")
    private Long createTime;

    /**
     * 消息的类型，此时固定为event
     */
    @JacksonXmlProperty(localName = "MsgType")
    private String msgType;

    /**
     * 事件的类型
     */
    @JacksonXmlProperty(localName = "Event")
    private String event;

    @JacksonXmlProperty(localName = "BatchJob")
    private BatchJob batchJob;

    @Data
    public static class BatchJob implements Serializable {
        private static final long serialVersionUID = 1L;

        /**
         * 异步任务id，最大长度为64字符
         */
        @JacksonXmlProperty(localName = "JobId")
        private String jobId;

        /**
         * 操作类型，字符串，目前分别有：sync_user(增量更新成员)、 replace_user(全量覆盖成员）、invite_user(邀请成员关注）、replace_party(全量覆盖部门)
         */
        @JacksonXmlProperty(localName = "JobType")
        private String jobType;

        @JacksonXmlProperty(localName = "ErrCode")
        private Integer errCode;

        @JacksonXmlProperty(localName = "ErrMsg")
        private String errMsg;
    }
}
