/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.callback.provider;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.io.Serializable;

import lombok.Data;

/**
 * 注册完成回调事件
 * 
 * InfoType 事件类型，此处固定为register_corp，注册回调事件
 * 
 * @title RegisterCorp
 * @author yanmaoyuan
 * @date 2021年4月26日
 * @version 1.0
 * @see https://work.weixin.qq.com/api/doc/90001/90143/90585
 */
@Data
@JacksonXmlRootElement(localName = "xml")
public class RegisterCorp implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 服务商corpid
     */
    @JacksonXmlProperty(localName = "ServiceCorpId")
    private String serviceCorpId;

    /**
     * 消息的类型
     */
    @JacksonXmlProperty(localName = "InfoType")
    private String infoType;

    /**
     * 回调事件的时间戳
     */
    @JacksonXmlProperty(localName = "TimeStamp")
    private Long timestamp;

    /**
     * 创建企业对应的注册码
     */
    @JacksonXmlProperty(localName = "RegisterCode")
    private String registerCode;

    /**
     * 注册成功的企业corpid
     */
    @JacksonXmlProperty(localName = "AuthCorpId")
    private String authCorpId;

    /**
     * 通讯录迁移的凭证信息。仅当注册推广包开启通讯录迁移接口时返回该参数
     */
    @JacksonXmlProperty(localName = "ContactSync")
    private ContactSync contactSync;

    /**
     * 授权管理员的信息
     */
    @JacksonXmlProperty(localName = "AuthUserInfo")
    private AuthUserInfo authUserInfo;

    /**
     * 用户自定义的状态值，参数值由接口 获取注册码 指定。若未指定，则无该字段
     * @see https://work.weixin.qq.com/api/doc/90001/90143/90581
     */
    @JacksonXmlProperty(localName = "State")
    private String state;

    /**
     * 推广包ID
     */
    @JacksonXmlProperty(localName = "TemplateId")
    private String templateId;

    @Data
    public static class ContactSync implements Serializable {
        private static final long serialVersionUID = 1L;

        /**
         * 通讯录api接口调用凭证，有全部通讯录读写权限
         */
        @JacksonXmlProperty(localName = "AccessToken")
        private String accessToken;

        /**
         * AccessToken的有效时间（秒）
         */
        @JacksonXmlProperty(localName = "ExpiresIn")
        private Integer expiresIn;
    }

    @Data
    public static class AuthUserInfo implements Serializable {
        private static final long serialVersionUID = 1L;

        /**
         * 授权管理员的userid
         */
        @JacksonXmlProperty(localName = "UserId")
        private String userId;
    }

}
