/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.crypt;

import cn.kinyun.wework.sdk.crypt.AesException;
import cn.kinyun.wework.sdk.crypt.ByteGroup;
import cn.kinyun.wework.sdk.crypt.PKCS7Encoder;
import cn.kinyun.wework.sdk.crypt.SHA1;
import cn.kinyun.wework.sdk.crypt.XMLParse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import java.util.Base64;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WXBizMsgCrypt {
    private static final Logger log = LoggerFactory.getLogger(WXBizMsgCrypt.class);
    static final Charset CHARSET = StandardCharsets.UTF_8;
    Base64.Decoder decoder = Base64.getDecoder();
    Base64.Encoder encoder = Base64.getEncoder();
    byte[] aesKey;
    String token;
    String receiveid;
    private final Random random = new Random();

    public WXBizMsgCrypt(String token, String encodingAesKey, String receiveid) throws AesException {
        if (encodingAesKey.length() != 43) {
            throw new AesException(-40004);
        }
        this.token = token;
        this.receiveid = receiveid;
        this.aesKey = this.decoder.decode(encodingAesKey + "=");
    }

    byte[] getNetworkBytesOrder(int sourceNumber) {
        byte[] orderBytes = new byte[4];
        orderBytes[3] = (byte)(sourceNumber & 0xFF);
        orderBytes[2] = (byte)(sourceNumber >> 8 & 0xFF);
        orderBytes[1] = (byte)(sourceNumber >> 16 & 0xFF);
        orderBytes[0] = (byte)(sourceNumber >> 24 & 0xFF);
        return orderBytes;
    }

    int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 0xFF;
        }
        return sourceNumber;
    }

    String getRandomStr() {
        String base = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            int number = this.random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    String encrypt(String randomStr, String text) throws AesException {
        ByteGroup byteCollector = new ByteGroup();
        byte[] randomStrBytes = randomStr.getBytes(CHARSET);
        byte[] textBytes = text.getBytes(CHARSET);
        byte[] networkBytesOrder = this.getNetworkBytesOrder(textBytes.length);
        byte[] receiveidBytes = this.receiveid.getBytes(CHARSET);
        byteCollector.addBytes(randomStrBytes);
        byteCollector.addBytes(networkBytesOrder);
        byteCollector.addBytes(textBytes);
        byteCollector.addBytes(receiveidBytes);
        byte[] padBytes = PKCS7Encoder.encode(byteCollector.size());
        byteCollector.addBytes(padBytes);
        byte[] unencrypted = byteCollector.toBytes();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            return this.encoder.encodeToString(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AesException(-40006);
        }
    }

    public String decrypt(String text) throws AesException {
        String fromReceiveId;
        String xmlContent;
        byte[] original;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(this.aesKey, 0, 16));
            cipher.init(2, (Key)keySpec, iv);
            byte[] encrypted = this.decoder.decode(text);
            original = cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AesException(-40007);
        }
        try {
            byte[] bytes = PKCS7Encoder.decode(original);
            byte[] networkOrder = Arrays.copyOfRange(bytes, 16, 20);
            int xmlLength = this.recoverNetworkBytesOrder(networkOrder);
            xmlContent = new String(Arrays.copyOfRange(bytes, 20, 20 + xmlLength), CHARSET);
            fromReceiveId = new String(Arrays.copyOfRange(bytes, 20 + xmlLength, bytes.length), CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AesException(-40008);
        }
        if (!fromReceiveId.equals(this.receiveid)) {
            log.info("from_receiveid: {}, receiveid: {}", (Object)fromReceiveId, (Object)this.receiveid);
            throw new AesException(-40005);
        }
        return xmlContent;
    }

    public String encryptMsg(String replyMsg, String timeStamp, String nonce) throws AesException {
        String encrypt = this.encrypt(this.getRandomStr(), replyMsg);
        if ("".equals(timeStamp)) {
            timeStamp = Long.toString(System.currentTimeMillis());
        }
        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, encrypt);
        return XMLParse.generate(encrypt, signature, timeStamp, nonce);
    }

    public String decryptMsg(String msgSignature, String timeStamp, String nonce, String postData) throws AesException {
        Object[] encrypt = XMLParse.extract(postData);
        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, encrypt[1].toString());
        if (!signature.equals(msgSignature)) {
            throw new AesException(-40001);
        }
        return this.decrypt(encrypt[1].toString());
    }

    public String verifyURL(String msgSignature, String timeStamp, String nonce, String echoStr) throws AesException {
        String signature = SHA1.getSHA1(this.token, timeStamp, nonce, echoStr);
        if (!signature.equals(msgSignature)) {
            throw new AesException(-40001);
        }
        return this.decrypt(echoStr);
    }
}

