/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.crypt;

import cn.kinyun.wework.sdk.crypt.AesException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class SHA1 {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private SHA1() {
    }

    public static String getSHA1(String token, String timestamp, String nonce, String encrypt) throws AesException {
        Object[] array = new String[]{token, timestamp, nonce, encrypt};
        StringBuilder sb = new StringBuilder();
        Arrays.sort(array);
        for (int i = 0; i < 4; ++i) {
            sb.append((String)array[i]);
        }
        String str = sb.toString();
        return SHA1.sha1(str);
    }

    public static String sha1(String str) throws AesException {
        byte[] digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(str.getBytes());
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new AesException(-40003);
        }
        return SHA1.toHexStr(digest);
    }

    public static String toHexStr(byte[] digest) {
        char[] value = new char[digest.length * 2];
        int i = 0;
        int idx = 0;
        while (i < digest.length) {
            value[idx] = HEX_DIGITS[digest[i] >> 4 & 0xF];
            value[idx + 1] = HEX_DIGITS[digest[i] & 0xF];
            ++i;
            idx += 2;
        }
        return new String(value);
    }
}

