/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.annotation.GenAsync;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.external.contactway.ConfigIdResp;
import cn.kinyun.wework.sdk.entity.external.contactway.ContactWay;
import cn.kinyun.wework.sdk.entity.external.contactway.ContactWayResp;
import cn.kinyun.wework.sdk.entity.external.contactway.FollowerUserResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class ContactWayApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.externalcontact.get_follow_user_list}")
    private String getFollowUserListUrl;
    @Value(value="${qyapi.externalcontact.add_contact_way}")
    private String addContactWayUrl;
    @Value(value="${qyapi.externalcontact.get_contact_way}")
    private String getContactWayUrl;
    @Value(value="${qyapi.externalcontact.update_contact_way}")
    private String updateContactWayUrl;
    @Value(value="${qyapi.externalcontact.del_contact_way}")
    private String delContactWayUrl;

    public List<String> getFollowUserList(@NonNull String accessToken) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getFollowUserListUrl, accessToken);
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, FollowerUserResp.class, new Object[0]);
        FollowerUserResp result = (FollowerUserResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getFollowUser();
    }

    public ContactWay get(@NonNull String accessToken, @NonNull String configId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (configId == null) {
            throw new NullPointerException("configId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getContactWayUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("config_id", configId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ContactWayResp.class, new Object[0]);
        ContactWayResp result = (ContactWayResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getContactWay();
    }

    @GenAsync
    public ConfigIdResp create(@NonNull String accessToken, @NonNull ContactWay params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.addContactWayUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ConfigIdResp.class, new Object[0]);
        ConfigIdResp result = (ConfigIdResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenAsync
    public void update(@NonNull String accessToken, @NonNull ContactWay contactWay) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (contactWay == null) {
            throw new NullPointerException("contactWay is marked non-null but is null");
        }
        String url = MessageFormat.format(this.updateContactWayUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)contactWay, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }

    @GenAsync
    public void delete(@NonNull String accessToken, @NonNull String configId) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (configId == null) {
            throw new NullPointerException("configId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.delContactWayUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("config_id", configId);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, ErrorCode.class, new Object[0]);
        ErrorCode result = (ErrorCode)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
    }
}

