package cn.kinyun.wework.sdk.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2023/11/2
 */
@Slf4j
@Configuration
public class WeworkSdkThreadLocalProxyFactoryConfig {

    @Bean
    public WeoworkSdkThreadLocalProxySimpleRequestFactory getFactory(@Autowired @Qualifier("weworkRestTemplate") RestTemplate weworkRestTemplate) {
        log.info("init thread local proxy factory");
        WeoworkSdkThreadLocalProxySimpleRequestFactory factory = new WeoworkSdkThreadLocalProxySimpleRequestFactory();
        factory.setConnectTimeout(60000);
        factory.setReadTimeout(60000);
        weworkRestTemplate.setRequestFactory(factory);

        return factory;
    }
}