/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.utils;

import java.io.StringWriter;
import java.io.Writer;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public final class RSAGenerator {
    private RSAGenerator() {
    }

    public static Pair<String, String> getNewRSAPairWithPKCS8(int keySize) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
            keyPairGenerator.initialize(keySize);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            String publicKey = RSAGenerator.getPEMString(keyPair.getPublic());
            String privateKey = RSAGenerator.getPEMPrivateString(keyPair.getPrivate());
            return new ImmutablePair((Object)publicKey, (Object)privateKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getPEMPrivateString(PrivateKey key) {
        StringWriter writer = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
        try {
            pemWriter.writeObject((PemObjectGenerator)new JcaPKCS8Generator(key, null));
            pemWriter.close();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    private static String getPEMString(Key key) {
        StringWriter writer = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
        try {
            pemWriter.writeObject((Object)key);
            pemWriter.close();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return writer.toString();
    }
}

