/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.annotation.GenAsync;
import cn.kinyun.wework.sdk.annotation.GenLock;
import cn.kinyun.wework.sdk.annotation.GenNullable;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.external.transfer.TransferCustomerParams;
import cn.kinyun.wework.sdk.entity.external.transfer.TransferCustomerResp;
import cn.kinyun.wework.sdk.entity.external.transfer.TransferGroupChatResp;
import cn.kinyun.wework.sdk.entity.external.transfer.TransferResult;
import cn.kinyun.wework.sdk.entity.external.transfer.UnassignedListResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Set;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class TransferApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.externalcontact.transfer_customer}")
    private String transferCustomerUrl;
    @Value(value="${qyapi.externalcontact.transfer_result}")
    private String transferResultUrl;
    @Value(value="${qyapi.externalcontact.get_unassigned_list}")
    private String unassignedListUrl;
    @Value(value="${qyapi.externalcontact.resigned.transfer_customer}")
    private String transferCustomerOfDimissionUrl;
    @Value(value="${qyapi.externalcontact.resigned.transfer_result}")
    private String transferResultOfDimissionUrl;
    @Value(value="${qyapi.externalcontact.groupchat.transfer}")
    private String transferGroupChatUrl;

    @GenAsync
    public TransferCustomerResp transferCustomer(@NonNull String accessToken, @NonNull TransferCustomerParams params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.transferCustomerUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, TransferCustomerResp.class, new Object[0]);
        TransferCustomerResp result = (TransferCustomerResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public TransferResult getTransferResult(@NonNull String accessToken, @NonNull String handoverUserId, @NonNull String takeoverUserId, @GenNullable String cursor) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (handoverUserId == null) {
            throw new NullPointerException("handoverUserId is marked non-null but is null");
        }
        if (takeoverUserId == null) {
            throw new NullPointerException("takeoverUserId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.transferResultUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("handover_userid", handoverUserId);
        params.put("takeover_userid", takeoverUserId);
        params.put("cursor", cursor);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, TransferResult.class, new Object[0]);
        TransferResult result = (TransferResult)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenLock
    public UnassignedListResp getUnassignedList(@NonNull String accessToken, @GenNullable Integer pageId, @GenNullable Integer pageSize, @GenNullable String cursor) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        String url = MessageFormat.format(this.unassignedListUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("page_id", pageId);
        params.put("page_size", pageSize);
        params.put("cursor", cursor);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UnassignedListResp.class, new Object[0]);
        UnassignedListResp result = (UnassignedListResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    @GenAsync
    public TransferCustomerResp dimissionTransferCustomer(@NonNull String accessToken, @NonNull TransferCustomerParams params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.transferCustomerOfDimissionUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, TransferCustomerResp.class, new Object[0]);
        TransferCustomerResp result = (TransferCustomerResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public TransferResult getTransferResultOfDimission(@NonNull String accessToken, @NonNull String handoverUserId, @NonNull String takeoverUserId, @GenNullable String cursor) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (handoverUserId == null) {
            throw new NullPointerException("handoverUserId is marked non-null but is null");
        }
        if (takeoverUserId == null) {
            throw new NullPointerException("takeoverUserId is marked non-null but is null");
        }
        String url = MessageFormat.format(this.transferResultOfDimissionUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("handover_userid", handoverUserId);
        params.put("takeover_userid", takeoverUserId);
        params.put("cursor", cursor);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, TransferResult.class, new Object[0]);
        TransferResult result = (TransferResult)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public TransferGroupChatResp transferGroupChat(@NonNull String accessToken, @NonNull Set<String> chatIds, @NonNull String newOwner) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (chatIds == null) {
            throw new NullPointerException("chatIds is marked non-null but is null");
        }
        if (newOwner == null) {
            throw new NullPointerException("newOwner is marked non-null but is null");
        }
        String url = MessageFormat.format(this.transferGroupChatUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("chat_id_list", chatIds);
        params.put("new_owner", newOwner);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, TransferGroupChatResp.class, new Object[0]);
        TransferGroupChatResp result = (TransferGroupChatResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

