/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.external.statistic.BehaviorData;
import cn.kinyun.wework.sdk.entity.external.statistic.GroupChatStatisticParam;
import cn.kinyun.wework.sdk.entity.external.statistic.GroupStatisticResult;
import cn.kinyun.wework.sdk.entity.external.statistic.UserBehaviorData;
import cn.kinyun.wework.sdk.entity.external.statistic.UserBehaviorParams;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import java.util.List;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class ExternalStatisticApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.statistic.get_user_behavior_data}")
    private String getUserBehaviorDataUrl;
    @Value(value="${qyapi.statistic.group_by_creator}")
    private String statisticGroupByCreatorUrl;

    public List<BehaviorData> getUserBehaviorData(@NonNull String accessToken, @NonNull UserBehaviorParams userBehaviorParams) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (userBehaviorParams == null) {
            throw new NullPointerException("userBehaviorParams is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getUserBehaviorDataUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)userBehaviorParams, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserBehaviorData.class, new Object[0]);
        UserBehaviorData result = (UserBehaviorData)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result.getBehaviorDatas();
    }

    public GroupStatisticResult getGroupStatisticData(@NonNull String accessToken, @NonNull GroupChatStatisticParam groupChatStatisticParam) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (groupChatStatisticParam == null) {
            throw new NullPointerException("groupChatStatisticParam is marked non-null but is null");
        }
        String url = MessageFormat.format(this.statisticGroupByCreatorUrl, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)groupChatStatisticParam, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, GroupStatisticResult.class, new Object[0]);
        GroupStatisticResult result = (GroupStatisticResult)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

