/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.annotation.GenIgnore;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.oauth2.UserDetail;
import cn.kinyun.wework.sdk.entity.oauth2.Userdetail3rd;
import cn.kinyun.wework.sdk.entity.oauth2.Userinfo;
import cn.kinyun.wework.sdk.entity.oauth2.Userinfo3rd;
import cn.kinyun.wework.sdk.enums.SnsapiScope;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class WwOauth2Api {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.oauth2.suite_authorize}")
    private String wwSuiteAuthorizeUrl;
    @Value(value="${qyapi.oauth2.get_userinfo_3rd}")
    private String wwGetUserinfo3rd;
    @Value(value="${qyapi.oauth2.get_userinfo}")
    private String getWwGetUserinfo;
    @Value(value="${qyapi.oauth2.get_userdetail_3rd}")
    private String wwGetUserdetail3rd;
    @Value(value="${qyapi.oauth2.get_userinfo_detail}")
    private String getUserdetail;

    @GenIgnore
    public String getSuiteAuthorizeUrl(String appId, String redirectUri, SnsapiScope scope, String state, String agentId) {
        String url = MessageFormat.format(this.wwSuiteAuthorizeUrl, appId, redirectUri, scope.getValue(), state);
        if (agentId != null) {
            url = url + "&agentid=" + agentId + "#wechat_redirect";
        }
        return url;
    }

    public Userinfo3rd getUserinfo3rd(@NonNull String suiteAccessToken, @NonNull String code) throws WeworkException {
        if (suiteAccessToken == null) {
            throw new NullPointerException("suiteAccessToken is marked non-null but is null");
        }
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwGetUserinfo3rd, suiteAccessToken, code);
        ResponseEntity response = this.restTemplate.getForEntity(url, Userinfo3rd.class, new Object[0]);
        Userinfo3rd result = (Userinfo3rd)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public Userinfo getUserinfo(@NonNull String accessToken, @NonNull String code) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getWwGetUserinfo, accessToken, code);
        ResponseEntity responseEntity = this.restTemplate.getForEntity(url, Userinfo.class, new Object[0]);
        Userinfo result = (Userinfo)responseEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public Userdetail3rd getUserdetail3rd(@NonNull String suiteAccessToken, @NonNull String userTicket) throws WeworkException {
        if (suiteAccessToken == null) {
            throw new NullPointerException("suiteAccessToken is marked non-null but is null");
        }
        if (userTicket == null) {
            throw new NullPointerException("userTicket is marked non-null but is null");
        }
        String url = MessageFormat.format(this.wwGetUserdetail3rd, suiteAccessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("user_ticket", userTicket);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, Userdetail3rd.class, new Object[0]);
        Userdetail3rd result = (Userdetail3rd)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public UserDetail getUserdetail(@NonNull String accessToken, @NonNull String userTicket) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (userTicket == null) {
            throw new NullPointerException("userTicket is marked non-null but is null");
        }
        String url = MessageFormat.format(this.getUserdetail, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HashMap params = Maps.newHashMap();
        params.put("user_ticket", userTicket);
        HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, UserDetail.class, new Object[0]);
        UserDetail result = (UserDetail)response.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

