/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.api.req.AddCalendarReq;
import cn.kinyun.wework.sdk.api.req.CalendarDetailReq;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.calendar.CalendarAddResp;
import cn.kinyun.wework.sdk.entity.calendar.CalendarDetailResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import java.text.MessageFormat;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CalendarApi {
    @Autowired
    @Qualifier(value="weworkRestTemplate")
    private RestTemplate restTemplate;
    @Value(value="${qyapi.calendar.add}")
    private String addCalendar;
    @Value(value="${qyapi.calendar.get}")
    private String calendarDetail;

    public CalendarAddResp addCalendar(@NonNull String accessToken, @NonNull AddCalendarReq params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.addCalendar, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, CalendarAddResp.class, new Object[0]);
        CalendarAddResp result = (CalendarAddResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }

    public CalendarDetailResp getCalendarDetail(@NonNull String accessToken, @NonNull CalendarDetailReq params) throws WeworkException {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        String url = MessageFormat.format(this.calendarDetail, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity forEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, CalendarDetailResp.class, new Object[0]);
        CalendarDetailResp result = (CalendarDetailResp)forEntity.getBody();
        WeworkException.isSuccess((ErrorCode)result);
        return result;
    }
}

