package cn.kinyun.wework.sdk.utils;


import lombok.Getter;
import lombok.Setter;

import java.net.Proxy;

@Getter
@Setter
public final class WeworkSdkApiServiceContext {

    private String traceId;

    private String requestId;

    private Proxy proxy;

    private WeworkSdkApiServiceContext() {}

    private static final ThreadLocal<WeworkSdkApiServiceContext> LOCAL = ThreadLocal.withInitial(WeworkSdkApiServiceContext::new);

    public static WeworkSdkApiServiceContext getContext() {
        return LOCAL.get();
    }

    public static void removeContext() {
        LOCAL.remove();
    }

}
