/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.api.chat;

import cn.kinyun.wework.sdk.annotation.GenIgnore;
import cn.kinyun.wework.sdk.api.chat.ChatApiBuilder;
import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.chat.ChatData;
import cn.kinyun.wework.sdk.entity.chat.ChatMsg;
import cn.kinyun.wework.sdk.entity.chat.EncryptChatData;
import cn.kinyun.wework.sdk.exception.FinanceSdkException;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.tencent.wework.Finance;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import lombok.NonNull;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GenIgnore
public class ChatApi {
    private static final Logger log = LoggerFactory.getLogger(ChatApi.class);
    static final ObjectMapper OBJ_MAPPER = new ObjectMapper();
    private volatile long sdk;
    private String corpId;
    private String secret;
    private String proxy;
    private String passwd;
    private int timeout = 5;
    private final Map<String, PrivateKey> privateKeyMap = new HashMap<String, PrivateKey>();

    public ChatApi(@NonNull String corpId, @NonNull String secret) {
        if (corpId == null) {
            throw new NullPointerException("corpId is marked non-null but is null");
        }
        if (secret == null) {
            throw new NullPointerException("secret is marked non-null but is null");
        }
        this.corpId = corpId;
        this.secret = secret;
        this.initSdk();
    }

    public void addPrivateKey(@NonNull String version, @NonNull String privateKey) throws IOException {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        PrivateKey key = this.getPrivateKey(privateKey);
        this.privateKeyMap.put(version, key);
    }

    public void initSdk() throws FinanceSdkException {
        if (this.sdk != 0L) {
            throw new IllegalStateException("sdk is already initialized.");
        }
        long ptrSdk = Finance.NewSdk();
        long ret = Finance.Init(ptrSdk, this.corpId, this.secret);
        if (ret != 0L) {
            Finance.DestroySdk(ptrSdk);
            throw new FinanceSdkException(ret, "init sdk failed");
        }
        this.sdk = ptrSdk;
    }

    public void destroySdk() {
        if (this.sdk == 0L) {
            throw new IllegalStateException("sdk is not initialized before destroy.");
        }
        Finance.DestroySdk(this.sdk);
        this.sdk = 0L;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public ChatData getChatdata(Long seq, Integer limit) throws WeworkException {
        if (this.sdk == 0L) {
            throw new IllegalStateException("sdk is not initialized before destroy.");
        }
        long slice = Finance.NewSlice();
        long ret = Finance.GetChatData(this.sdk, seq, limit.intValue(), this.proxy, this.passwd, this.timeout, slice);
        if (ret != 0L) {
            Finance.FreeSlice(slice);
            throw new FinanceSdkException(ret, "\u83b7\u53d6\u804a\u5929\u6570\u636e\u5931\u8d25");
        }
        String content = Finance.GetContentFromSlice(slice);
        Finance.FreeSlice(slice);
        ChatData chatdata = null;
        try {
            chatdata = (ChatData)OBJ_MAPPER.readValue(content, ChatData.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u89e3\u6790\u804a\u5929\u6570\u636e\u5931\u8d25:{}", (Object)content, (Object)e);
            throw new FinanceSdkException(ret, "\u89e3\u6790\u804a\u5929\u6570\u636e\u5931\u8d25");
        }
        WeworkException.isSuccess((ErrorCode)chatdata);
        return chatdata;
    }

    public File getMediadata(String sdkfileid, String savefile) {
        long ptrMediaData;
        if (this.sdk == 0L) {
            throw new IllegalStateException("sdk is not initialized before destroy.");
        }
        long ret = 0L;
        File dirFolder = new File(System.getProperty("java.io.tmpdir"), "WeWorkFinanceSdk");
        if (!dirFolder.exists()) {
            dirFolder.mkdirs();
        }
        String tmpName = UUID.randomUUID().toString() + ".tmp";
        File tmpFile = new File(dirFolder, tmpName);
        File file = new File(savefile);
        String indexbuf = "";
        while (true) {
            if ((ret = (long)Finance.GetMediaData(this.sdk, indexbuf, sdkfileid, this.proxy, this.passwd, this.timeout, ptrMediaData = Finance.NewMediaData())) != 0L) {
                Finance.FreeMediaData(ptrMediaData);
                throw new FinanceSdkException(ret, "get media data failed");
            }
            int indexLen = Finance.GetIndexLen(ptrMediaData);
            int dataLen = Finance.GetDataLen(ptrMediaData);
            int isFinish = Finance.IsMediaDataFinish(ptrMediaData);
            log.info("getmediadata outindex len:{}, data_len:{}, is_finish:{}", new Object[]{indexLen, dataLen, isFinish});
            try (FileOutputStream outputStream = new FileOutputStream(tmpFile, true);){
                outputStream.write(Finance.GetData(ptrMediaData));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (isFinish == 1) break;
            indexbuf = Finance.GetOutIndexBuf(ptrMediaData);
            Finance.FreeMediaData(ptrMediaData);
        }
        Finance.FreeMediaData(ptrMediaData);
        try {
            Files.copy(tmpFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            tmpFile.delete();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            log.error("delete file failed.", (Throwable)ex);
        }
        return file;
    }

    public List<ChatMsg> decryptAll(List<EncryptChatData> list) throws FinanceSdkException, GeneralSecurityException {
        if (this.sdk == 0L) {
            throw new IllegalStateException("sdk is not initialized before destroy.");
        }
        ArrayList<ChatMsg> results = new ArrayList<ChatMsg>(list.size());
        for (EncryptChatData data : list) {
            results.add(this.decrypt(data));
        }
        return results;
    }

    public ChatMsg decrypt(EncryptChatData encryptChatData) throws FinanceSdkException, GeneralSecurityException {
        ChatMsg chatMsg;
        if (this.sdk == 0L) {
            throw new IllegalStateException("sdk is not initialized before destroy.");
        }
        String publickeyVer = encryptChatData.getPublickeyVer();
        String encryptRandomKey = encryptChatData.getEncryptRandomKey();
        String encryptChatMsg = encryptChatData.getEncryptChatMsg();
        PrivateKey prikey = this.privateKeyMap.get(publickeyVer);
        if (prikey == null) {
            throw new NullPointerException("RSA Private Key not found with version:" + publickeyVer);
        }
        byte[] randomKeyBytes = Base64.getDecoder().decode(encryptRandomKey);
        Cipher rsa = Cipher.getInstance("RSA/ECB/PKCS1Padding", "BC");
        rsa.init(2, prikey);
        byte[] encryptKeyBytes = rsa.doFinal(randomKeyBytes);
        String encryptKey = new String(encryptKeyBytes, StandardCharsets.UTF_8);
        long msg = Finance.NewSlice();
        long ret = Finance.DecryptData(this.sdk, encryptKey, encryptChatMsg, msg);
        if (ret != 0L) {
            Finance.FreeSlice(msg);
            throw new FinanceSdkException(ret, "decrypt data failed");
        }
        String content = Finance.GetContentFromSlice(msg);
        Finance.FreeSlice(msg);
        try {
            chatMsg = (ChatMsg)OBJ_MAPPER.readValue(content, ChatMsg.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u89e3\u6790\u804a\u5929\u6570\u636e\u5931\u8d25:{}", (Object)content, (Object)e);
            throw new FinanceSdkException(ret, "\u89e3\u6790\u804a\u5929\u6570\u636e\u5931\u8d25");
        }
        return chatMsg;
    }

    private PrivateKey getPrivateKey(String privateKey) throws IOException {
        try (PEMParser parser = new PEMParser((Reader)new StringReader(privateKey));){
            Object obj = parser.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            converter.setProvider("BC");
            if (obj instanceof PEMKeyPair) {
                PEMKeyPair pair = (PEMKeyPair)obj;
                PrivateKeyInfo privateKeyInfo = pair.getPrivateKeyInfo();
                PrivateKey privateKey2 = converter.getPrivateKey(privateKeyInfo);
                return privateKey2;
            }
            if (obj instanceof PrivateKeyInfo) {
                PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)obj;
                PrivateKey privateKey3 = converter.getPrivateKey(privateKeyInfo);
                return privateKey3;
            }
            log.warn("read private key failed:{}", obj);
        }
        return null;
    }

    public static ChatApiBuilder builder() {
        return new ChatApiBuilder();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        log.info("add BouncyCastle Provider");
        OBJ_MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        OBJ_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJ_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

